/*
 * Copyright (c) 2020, 2022, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.internal.foreign.abi;

/**
 * Carrier class used to communicate with the VM
 *
 * It is particularly low-level since the VM will be accessing these fields directly
 */
public class ABIDescriptor {
    final Architecture arch;

    public final VMStorage[][] inputStorage;
    public final VMStorage[][] outputStorage;

    final VMStorage[][] volatileStorage;

    final int stackAlignment;
    final int shadowSpace;

    final VMStorage targetAddrStorage;
    final VMStorage retBufAddrStorage;

    public ABIDescriptor(Architecture arch, VMStorage[][] inputStorage, VMStorage[][] outputStorage,
                         VMStorage[][] volatileStorage, int stackAlignment, int shadowSpace,
                         VMStorage targetAddrStorage, VMStorage retBufAddrStorage) {
        this.arch = arch;
        this.inputStorage = inputStorage;
        this.outputStorage = outputStorage;
        this.volatileStorage = volatileStorage;
        this.stackAlignment = stackAlignment;
        this.shadowSpace = shadowSpace;
        this.targetAddrStorage = targetAddrStorage;
        this.retBufAddrStorage = retBufAddrStorage;
    }

    public VMStorage targetAddrStorage() {
        return targetAddrStorage;
    }

    public VMStorage retBufAddrStorage() {
        return retBufAddrStorage;
    }
}
