/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl;

import com.sun.net.ssl.SSLSecurity;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactorySpi;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;

@Deprecated
public class TrustManagerFactory {
    private Provider provider;
    private TrustManagerFactorySpi factorySpi;
    private String algorithm;

    public static final String getDefaultAlgorithm() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("sun.ssl.trustmanager.type");
            }
        });
        if (string == null) {
            string = "SunX509";
        }
        return string;
    }

    protected TrustManagerFactory(TrustManagerFactorySpi trustManagerFactorySpi, Provider provider, String string) {
        this.factorySpi = trustManagerFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final TrustManagerFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = SSLSecurity.getImpl(string, "TrustManagerFactory", (String)null);
            return new TrustManagerFactory((TrustManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static final TrustManagerFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SSLSecurity.getImpl(string, "TrustManagerFactory", string2);
        return new TrustManagerFactory((TrustManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static final TrustManagerFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SSLSecurity.getImpl(string, "TrustManagerFactory", provider);
        return new TrustManagerFactory((TrustManagerFactorySpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void init(KeyStore keyStore) throws KeyStoreException {
        this.factorySpi.engineInit(keyStore);
    }

    public TrustManager[] getTrustManagers() {
        return this.factorySpi.engineGetTrustManagers();
    }
}

