/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Stack;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveEntry;
import sun.util.logging.PlatformLogger;

class ClientVector
extends Stack<KeepAliveEntry> {
    private static final long serialVersionUID = -8680532108106489459L;
    int nap;

    ClientVector(int n) {
        this.nap = n;
    }

    synchronized HttpClient get() {
        if (this.empty()) {
            return null;
        }
        HttpClient httpClient = null;
        long l = System.currentTimeMillis();
        do {
            KeepAliveEntry keepAliveEntry = (KeepAliveEntry)this.pop();
            if (l - keepAliveEntry.idleStartTime > (long)this.nap) {
                keepAliveEntry.hc.closeServer();
                continue;
            }
            httpClient = keepAliveEntry.hc;
            if (!KeepAliveCache.logger.isLoggable(PlatformLogger.Level.FINEST)) continue;
            String string = "cached HttpClient was idle for " + Long.toString(l - keepAliveEntry.idleStartTime);
            KeepAliveCache.logger.finest(string);
        } while (httpClient == null && !this.empty());
        return httpClient;
    }

    synchronized void put(HttpClient httpClient) {
        if (this.size() >= KeepAliveCache.getMaxConnections()) {
            httpClient.closeServer();
        } else {
            this.push(new KeepAliveEntry(httpClient, System.currentTimeMillis()));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

