/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_my extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a";
        final String metaValue_BY = "\u1018\u102e\u101c\u102c\u101b\u102f\u1005\u103a";
        final String metaValue_BG = "\u1018\u1030\u101c\u103a\u1002\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_DK = "\u1012\u102d\u1014\u103a\u1038\u1019\u1010\u103a";
        final String metaValue_GR = "\u1002\u101b\u102d";
        final String metaValue_ES = "\u1005\u1015\u102d\u1014\u103a";
        final String metaValue_FI = "\u1016\u1004\u103a\u101c\u1014\u103a";
        final String metaValue_FJ = "\u1016\u102e\u1002\u103b\u102e";
        final String metaValue_FR = "\u1015\u103c\u1004\u103a\u101e\u1005\u103a";
        final String metaValue_HR = "\u1001\u101b\u102d\u102f\u1021\u1031\u1038\u101b\u103e\u102c\u1038";
        final String metaValue_HT = "\u101f\u1031\u1010\u102e";
        final String metaValue_HU = "\u101f\u1014\u103a\u1002\u1031\u101b\u102e";
        final String metaValue_AM = "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_ID = "\u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038";
        final String metaValue_IT = "\u1021\u102e\u1010\u101c\u102e";
        final String metaValue_JP = "\u1002\u103b\u1015\u1014\u103a";
        final String metaValue_GE = "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c";
        final String metaValue_CD = "\u1000\u103d\u1014\u103a\u1002\u102d\u102f";
        final String metaValue_LU = "\u101c\u1030\u1007\u1004\u103a\u1018\u1010\u103a";
        final String metaValue_LA = "\u101c\u102c\u1021\u102d\u102f";
        final String metaValue_LT = "\u101c\u1005\u103a\u101e\u1030\u101d\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_LV = "\u101c\u1010\u103a\u1017\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_MM = "\u1019\u103c\u1014\u103a\u1019\u102c";
        final String metaValue_NR = "\u1014\u1031\u102c\u103a\u101b\u1030\u1038";
        final String metaValue_NP = "\u1014\u102e\u1015\u1031\u102b";
        final String metaValue_NO = "\u1014\u1031\u102c\u103a\u101d\u1031";
        final String metaValue_PL = "\u1015\u102d\u102f\u101c\u1014\u103a";
        final String metaValue_PT = "\u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e";
        final String metaValue_SI = "\u1006\u101c\u102d\u102f\u1017\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_AL = "\u1021\u101a\u103a\u101c\u103a\u1018\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_RS = "\u1006\u102c\u1038\u1018\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_SZ = "\u1006\u103d\u102c\u1007\u102e\u101c\u1014\u103a";
        final String metaValue_SD = "\u1006\u1030\u1012\u1014\u103a";
        final String metaValue_SE = "\u1006\u103d\u102e\u1012\u1004\u103a";
        final String metaValue_TH = "\u1011\u102d\u102f\u1004\u103a\u1038";
        final String metaValue_TM = "\u1010\u102c\u1037\u1001\u103a\u1019\u1004\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a";
        final String metaValue_TO = "\u1010\u103d\u1014\u103a\u1002\u102b";
        final String metaValue_TR = "\u1010\u1030\u101b\u1000\u102e";
        final String metaValue_UA = "\u101a\u1030\u1000\u101b\u102d\u1014\u103a\u1038";
        final String metaValue_VN = "\u1017\u102e\u101a\u1000\u103a\u1014\u1019\u103a";
        final String metaValue_CN = "\u1010\u101b\u102f\u1010\u103a";
        final String metaValue_PH = "\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a";
        final String metaValue_MU = "\u1019\u1031\u102c\u101b\u1005\u103a\u101b\u103e";
        final String metaValue_PW = "\u1015\u101c\u102c\u1021\u102d\u102f";
        final String metaValue_SY = "\u1006\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_bn = "\u1018\u1004\u103a\u1039\u1002\u102b\u101c\u102e";
        final String metaValue_ET = "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_km = "\u1001\u1019\u102c";
        final String metaValue_ko = "\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_la = "\u101c\u1000\u103a\u1010\u1004\u103a";
        final String metaValue_ml = "\u1019\u101c\u1031\u101a\u102c\u101c\u1019\u103a";
        final String metaValue_mn = "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u101c\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_nqo = "\u1021\u103d\u1014\u103a\u1000\u102d\u102f";
        final String metaValue_ta = "\u1010\u1019\u102e\u1038\u101c\u103a";
        final String metaValue_bo = "\u1010\u102d\u1018\u1000\u103a";
        final String metaValue_peo = "\u1015\u102b\u101b\u103e\u1014\u103a \u1021\u101f\u1031\u102c\u1004\u103a\u1038";
        final Object[][] data = new Object[][] {
            { "001", "\u1000\u1019\u1039\u1018\u102c" },
            { "002", "\u1021\u102c\u1016\u101b\u102d\u1000" },
            { "003", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u1019\u1031\u101b\u102d\u1000\u1010\u102d\u102f\u1000\u103a" },
            { "005", "\u1010\u1031\u102c\u1004\u103a \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "009", "\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c\u1012\u1031\u101e" },
            { "011", "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "013", "\u1017\u101f\u102d\u102f \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "014", "\u1021\u101b\u103e\u1031\u1037 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "015", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "017", "\u1021\u101c\u101a\u103a \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "018", "\u1021\u102c\u1016\u101b\u102d\u1000 \u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038" },
            { "019", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a" },
            { "021", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "029", "\u1000\u102c\u101b\u1005\u103a\u1018\u102e\u101a\u1036" },
            { "030", "\u1021\u101b\u103e\u1031\u1037\u1021\u102c\u101b\u103e" },
            { "034", "\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u101b\u103e" },
            { "035", "\u1021\u101b\u103e\u1031\u1037\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u101b\u103e" },
            { "039", "\u1010\u1031\u102c\u1004\u103a\u1025\u101b\u1031\u102c\u1015" },
            { "053", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u1014\u103e\u1004\u1037\u103a \u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a" },
            { "054", "\u1019\u102e\u101c\u102c\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "057", "\u1019\u102d\u102f\u1000\u103a\u1001\u101b\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038 \u1012\u1031\u101e" },
            { "061", "\u1015\u102d\u102f\u101c\u102e\u1014\u102e\u101b\u103e\u102c\u1038" },
            { "142", "\u1021\u102c\u101b\u103e" },
            { "143", "\u1021\u101c\u101a\u103a\u1021\u102c\u101b\u103e" },
            { "145", "\u1021\u1014\u1031\u102c\u1000\u103a\u1021\u102c\u101b\u103e" },
            { "150", "\u1025\u101b\u1031\u102c\u1015" },
            { "151", "\u1021\u101b\u103e\u1031\u1037 \u1025\u101b\u1031\u102c\u1015" },
            { "154", "\u1019\u103c\u1031\u102c\u1000\u103a \u1025\u101b\u1031\u102c\u1015" },
            { "155", "\u1021\u1014\u1031\u102c\u1000\u103a \u1025\u101b\u1031\u102c\u1015" },
            { "202", "\u1006\u102c\u101f\u102c\u101b-\u1021\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "419", "\u101c\u1000\u103a\u1010\u1004\u103a\u1021\u1019\u1031\u101b\u102d\u1000" },
            { "AC", "\u1021\u1006\u1014\u103a\u1038\u101b\u103e\u1004\u103a\u1038\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "AD", "\u1021\u1014\u103a\u1012\u102d\u102f\u101b\u102c" },
            { "AE", "\u101a\u1030\u1021\u1031\u1021\u102e\u1038" },
            { "AF", "\u1021\u102c\u1016\u1002\u1014\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "AG", "\u1021\u1014\u103a\u1010\u102e\u1002\u103d\u102b\u1014\u103e\u1004\u1037\u103a \u1018\u102c\u1018\u1030\u1012\u102b" },
            { "AI", "\u1021\u1014\u103a\u1002\u102e\u101c\u102c" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "\u1021\u1014\u103a\u1002\u102d\u102f\u101c\u102c" },
            { "AQ", "\u1021\u1014\u103a\u1010\u102c\u1010\u102d\u1000" },
            { "AR", "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038" },
            { "AS", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1006\u1019\u102d\u102f\u1038\u1021\u102c\u1038" },
            { "AT", "\u1029\u1005\u1010\u103c\u102e\u1038\u101a\u102c\u1038" },
            { "AU", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b" },
            { "AW", "\u1021\u102c\u101b\u1030\u1038\u1017\u102c\u1038" },
            { "AX", "\u1021\u102c\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "AZ", metaValue_AZ },
            { "BA", "\u1018\u1031\u102c\u1037\u1005\u1014\u102e\u1038\u101a\u102c\u1038\u1014\u103e\u1004\u1037\u103a \u101f\u102c\u1007\u102e\u1002\u102d\u102f\u1017\u102e\u1014\u102c\u1038" },
            { "BB", "\u1018\u102c\u1018\u1031\u1038\u1012\u102d\u102f\u1038\u1005\u103a" },
            { "BD", "\u1018\u1004\u103a\u1039\u1002\u101c\u102c\u1038\u1012\u1031\u1037\u101b\u103e\u103a" },
            { "BE", "\u1018\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u101a\u1019\u103a" },
            { "BF", "\u1018\u102c\u1000\u102e\u1038\u1014\u102c\u1038 \u1016\u102c\u1038\u1006\u102d\u102f" },
            { "BG", metaValue_BG },
            { "BH", "\u1018\u102c\u101b\u102d\u1014\u103a\u1038" },
            { "BI", "\u1018\u1030\u101b\u103d\u1014\u103a\u1012\u102e" },
            { "BJ", "\u1018\u102e\u1014\u1004\u103a" },
            { "BL", "\u1005\u102d\u1014\u1037\u103a\u1018\u102c\u101e\u101a\u103a\u101c\u103a\u1019\u102e" },
            { "BM", "\u1018\u102c\u1019\u103c\u1030\u1012\u102b" },
            { "BN", "\u1018\u101b\u1030\u1014\u102d\u102f\u1004\u103a\u1038" },
            { "BO", "\u1018\u102d\u102f\u101c\u102e\u1038\u1017\u102e\u1038\u101a\u102c\u1038" },
            { "BQ", "\u1000\u102c\u101b\u1005\u103a\u1018\u102e\u101a\u1036 \u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a" },
            { "BR", "\u1018\u101b\u102c\u1007\u102e\u1038" },
            { "BS", "\u1018\u101f\u102c\u1038\u1019\u102c\u1038" },
            { "BT", "\u1018\u1030\u1010\u1014\u103a" },
            { "BV", "\u1018\u1030\u1017\u1000\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "BW", "\u1018\u1031\u102c\u1037\u1006\u103d\u102c\u1014\u102c" },
            { "BY", metaValue_BY },
            { "BZ", "\u1018\u101c\u102d\u1007\u103a" },
            { "CA", "\u1000\u1014\u1031\u1012\u102b" },
            { "CC", "\u1000\u102d\u102f\u1000\u102d\u102f\u1038\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "CD", metaValue_CD },
            { "CF", "\u1017\u101f\u102d\u102f \u1021\u102c\u1016\u101b\u102d\u1000 \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f" },
            { "CG", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f-\u1018\u101b\u102c\u1007\u102c\u1017\u102e\u1038\u101c\u103a" },
            { "CH", "\u1006\u103d\u1005\u103a\u1007\u102c\u101c\u1014\u103a" },
            { "CI", "\u1000\u102d\u102f\u1037\u1010\u103a \u1012\u102e\u1017\u103d\u102c" },
            { "CK", "\u1000\u103d\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "CL", "\u1001\u103b\u102e\u101c\u102e" },
            { "CM", "\u1000\u1004\u103a\u1019\u101b\u103d\u1014\u103a\u1038" },
            { "CN", metaValue_CN },
            { "CO", "\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c" },
            { "CP", "\u1000\u101c\u1005\u103a\u1015\u102b\u1010\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "CR", "\u1000\u102d\u102f\u1037\u1005\u103a\u1010\u102c\u101b\u102e\u1000\u102c" },
            { "CU", "\u1000\u103b\u1030\u1038\u1018\u102c\u1038" },
            { "CV", "\u1000\u102d\u1010\u103a\u1017\u102c\u1012\u102e" },
            { "CW", "\u1000\u103b\u1030\u101b\u1031\u1038\u1000\u102d\u102f\u1038\u1005\u103a" },
            { "CX", "\u1001\u101b\u1005\u103a\u1005\u1019\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038" },
            { "CY", "\u1006\u102d\u102f\u1000\u103a\u1015\u101b\u1015\u103a\u1005\u103a" },
            { "CZ", "\u1001\u103b\u1000\u103a\u1000\u102e\u101a\u102c\u1038" },
            { "DE", "\u1002\u103b\u102c\u1019\u1014\u102e" },
            { "DG", "\u1012\u102e\u1021\u1032\u1002\u102d\u102f\u1002\u102b\u1005\u102e\u101b\u102c" },
            { "DJ", "\u1002\u103b\u102e\u1018\u1030\u1010\u102e" },
            { "DK", metaValue_DK },
            { "DM", "\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u102c" },
            { "DO", "\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u1014\u103a" },
            { "DZ", "\u1021\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "EA", "\u1006\u101a\u103a\u1025\u1010\u102c\u1014\u103e\u1004\u1037\u103a\u1019\u101a\u103a\u101c\u102e\u101c\u103a\u101c\u102c" },
            { "EC", "\u1021\u102e\u1000\u103d\u1031\u1012\u1031\u102b" },
            { "EE", "\u1021\u1000\u103a\u1005\u1010\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "EG", "\u1021\u102e\u1002\u103b\u1005\u103a" },
            { "EH", "\u1021\u1014\u1031\u102c\u1000\u103a \u1006\u102c\u101f\u102c\u101b" },
            { "ER", "\u1021\u102e\u101b\u102e\u1011\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "\u1025\u101b\u1031\u102c\u1015\u101e\u1019\u1002\u1039\u1002" },
            { "EZ", "\u1025\u101b\u1031\u102c\u1015\u1012\u1031\u101e" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "\u1016\u1031\u102c\u1037\u1000\u101c\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "FM", "\u1019\u102d\u102f\u1004\u103a\u1001\u101b\u102d\u102f\u1014\u102e\u101b\u103e\u102c\u1038" },
            { "FO", "\u1016\u102c\u101b\u102d\u102f\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038" },
            { "FR", metaValue_FR },
            { "GA", "\u1002\u102b\u1018\u103d\u1014\u103a" },
            { "GB", "\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1000\u1004\u103a\u1038\u1012\u1019\u103a\u1038" },
            { "GD", "\u1002\u101b\u102e\u1014\u1031\u1012\u102b" },
            { "GE", metaValue_GE },
            { "GF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1002\u102e\u101a\u102c\u1014\u102c" },
            { "GG", "\u1002\u103d\u1014\u103a\u1038\u1007\u102e" },
            { "GH", "\u1002\u102b\u1014\u102c" },
            { "GI", "\u1002\u103b\u102e\u1018\u101b\u1031\u102c\u103a\u101c\u103a\u1010\u102c" },
            { "GL", "\u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038" },
            { "GM", "\u1002\u1019\u103a\u1018\u102e\u101b\u102c" },
            { "GN", "\u1002\u102e\u1014\u102e" },
            { "GP", "\u1002\u103d\u102b\u1012\u102e\u101c\u102f" },
            { "GQ", "\u1021\u102e\u1000\u103d\u1031\u1010\u102c \u1002\u102e\u1014\u102e" },
            { "GR", metaValue_GR },
            { "GS", "\u1010\u1031\u102c\u1004\u103a \u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1014\u103e\u1004\u1037\u103a \u1010\u1031\u102c\u1004\u103a \u1006\u1004\u103a\u1038\u1012\u101d\u1005\u103a\u1002\u103b\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038" },
            { "GT", "\u1002\u103d\u102b\u1010\u102e\u1019\u102c\u101c\u102c" },
            { "GU", "\u1002\u1030\u1021\u1019\u103a" },
            { "GW", "\u1002\u102e\u1014\u102e-\u1018\u102e\u1005\u1031\u102c" },
            { "GY", "\u1002\u102d\u102f\u1004\u103a\u101a\u102c\u1014\u102c" },
            { "HK", "\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a (\u1010\u101b\u102f\u1010\u103a\u1015\u103c\u100a\u103a)" },
            { "HM", "\u101f\u1010\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1014\u103e\u1004\u1037\u103a\u1019\u1000\u103a\u1012\u1031\u102b\u1014\u101a\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "HN", "\u101f\u103d\u1014\u103a\u1012\u1030\u1038\u101b\u1015\u103a\u1005\u103a" },
            { "HR", metaValue_HR },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "\u1000\u1014\u1031\u101b\u102e \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "ID", metaValue_ID },
            { "IE", "\u1021\u102d\u102f\u1004\u103a\u101a\u102c\u101c\u1014\u103a" },
            { "IL", "\u1021\u1005\u1039\u1005\u101b\u1031\u1038" },
            { "IM", "\u1019\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "IN", "\u1021\u102d\u1014\u1039\u1012\u102d\u101a" },
            { "IO", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e\u1015\u102d\u102f\u1004\u103a \u1021\u102d\u1014\u1039\u1012\u102d\u101a\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1019\u103b\u102c\u1038" },
            { "IQ", "\u1021\u102e\u101b\u1010\u103a" },
            { "IR", "\u1021\u102e\u101b\u1014\u103a" },
            { "IS", "\u1021\u102d\u102f\u1000\u103a\u1005\u101c\u1014\u103a" },
            { "IT", metaValue_IT },
            { "JE", "\u1002\u103b\u102c\u1005\u102e" },
            { "JM", "\u1002\u103b\u1019\u1031\u1000\u102c" },
            { "JO", "\u1002\u103b\u1031\u102c\u103a\u1012\u1014\u103a" },
            { "JP", metaValue_JP },
            { "KE", "\u1000\u1004\u103a\u100a\u102c" },
            { "KG", "\u1000\u102c\u1002\u103b\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "KH", "\u1000\u1019\u1039\u1018\u1031\u102c\u1012\u102e\u1038\u101a\u102c\u1038" },
            { "KI", "\u1001\u102e\u101b\u102e\u1018\u102c\u1010\u102e" },
            { "KM", "\u1000\u102d\u102f\u1019\u102d\u102f\u101b\u102d\u102f\u1005\u103a" },
            { "KN", "\u1005\u102d\u1014\u1037\u103a\u1000\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1014\u102e\u1017\u102e\u1005\u103a" },
            { "KP", "\u1019\u103c\u1031\u102c\u1000\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "KR", "\u1010\u1031\u102c\u1004\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "KW", "\u1000\u1030\u101d\u102d\u1010\u103a" },
            { "KY", "\u1000\u1031\u1019\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "KZ", "\u1000\u102c\u1007\u1000\u103a\u1005\u1010\u1014\u103a" },
            { "LA", metaValue_LA },
            { "LB", "\u101c\u1000\u103a\u1018\u1014\u103d\u1014\u103a" },
            { "LC", "\u1005\u102d\u1014\u1037\u103a\u101c\u1030\u1005\u102e\u101a\u102c" },
            { "LI", "\u101c\u1005\u103a\u1010\u1014\u103a\u1005\u1010\u102d\u1014\u103a\u1038" },
            { "LK", "\u101e\u102e\u101b\u102d\u101c\u1004\u103a\u1039\u1000\u102c" },
            { "LR", "\u101c\u102d\u102f\u1000\u103a\u1018\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "LS", "\u101c\u102e\u1006\u102d\u102f\u101e\u102d\u102f" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "\u101c\u1005\u103a\u1017\u103b\u102c\u1038" },
            { "MA", "\u1019\u1031\u102c\u103a\u101b\u102d\u102f\u1000\u102d\u102f" },
            { "MC", "\u1019\u102d\u102f\u1014\u102c\u1000\u102d\u102f" },
            { "MD", "\u1019\u1031\u102c\u101c\u103a\u1012\u102d\u102f\u1017\u102c" },
            { "ME", "\u1019\u103d\u1014\u103a\u1010\u102e\u1014\u102d\u1002\u101b\u102d\u102f\u1038" },
            { "MF", "\u1005\u102d\u1014\u1037\u103a\u1019\u102c\u1010\u1004\u103a" },
            { "MG", "\u1019\u1012\u102b\u1002\u1010\u103a\u1005\u1000\u102c\u1038" },
            { "MH", "\u1019\u102c\u101b\u103e\u101a\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "MK", "\u1019\u103c\u1031\u102c\u1000\u103a \u1019\u1000\u103a\u1006\u102e\u1012\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "ML", "\u1019\u102c\u101c\u102e" },
            { "MM", metaValue_MM },
            { "MN", "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u1038\u101c\u102e\u1038\u101a\u102c\u1038" },
            { "MO", "\u1019\u1000\u102c\u1021\u102d\u102f (\u1010\u101b\u102f\u1010\u103a\u1015\u103c\u100a\u103a)" },
            { "MP", "\u1019\u103c\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1019\u102c\u101b\u102e\u1021\u102c\u1014\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "MQ", "\u1019\u102c\u1010\u102e\u1014\u102d\u1001\u103a" },
            { "MR", "\u1019\u1031\u102c\u103a\u101b\u102e\u1010\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "MS", "\u1019\u1031\u102c\u1004\u1037\u103a\u1005\u1032\u101b\u1000\u103a" },
            { "MT", "\u1019\u1031\u102c\u101c\u103a\u1010\u102c" },
            { "MU", metaValue_MU },
            { "MV", "\u1019\u1031\u102c\u103a\u101c\u103a\u1012\u102d\u102f\u1000\u103a" },
            { "MW", "\u1019\u102c\u101c\u102c\u101d\u102e" },
            { "MX", "\u1019\u1000\u103a\u1000\u1006\u102e\u1000\u102d\u102f" },
            { "MY", "\u1019\u101c\u1031\u1038\u101b\u103e\u102c\u1038" },
            { "MZ", "\u1019\u102d\u102f\u1007\u1019\u103a\u1018\u1005\u103a" },
            { "NA", "\u1014\u1019\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038" },
            { "NC", "\u1014\u101a\u1030\u1038 \u1000\u101a\u103a\u101c\u102e\u1012\u102d\u102f\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "NE", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102c" },
            { "NF", "\u1014\u1031\u102c\u1016\u102f\u1010\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "NG", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "NI", "\u1014\u102e\u1000\u102c\u101b\u102c\u1002\u103d\u102b" },
            { "NL", "\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a" },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "\u1014\u102e\u1025\u1030\u1021\u1031" },
            { "NZ", "\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a" },
            { "OM", "\u1021\u102d\u102f\u1019\u1014\u103a" },
            { "PA", "\u1015\u1014\u102c\u1038\u1019\u102c\u1038" },
            { "PE", "\u1015\u102e\u101b\u1030\u1038" },
            { "PF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1015\u1031\u102b\u103a\u101c\u102e\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "PG", "\u1015\u102b\u1015\u1030\u1021\u102c \u1014\u101a\u1030\u1038\u1002\u102e\u1014\u102e" },
            { "PH", metaValue_PH },
            { "PK", "\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "PL", metaValue_PL },
            { "PM", "\u1005\u102d\u1014\u1037\u103a\u1015\u102e\u1021\u1032\u101b\u103a\u1014\u103e\u1004\u1037\u103a \u1019\u102e\u1000\u103d\u102e\u101c\u103d\u1014\u103a" },
            { "PN", "\u1015\u1005\u103a\u1010\u103a\u1000\u102d\u1014\u103a\u1038\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "PR", "\u1015\u1031\u102b\u103a\u1010\u102d\u102f\u101b\u102e\u1000\u102d\u102f" },
            { "PS", "\u1015\u102b\u101c\u1000\u103a\u1005\u1010\u102d\u102f\u1004\u103a\u1038 \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a" },
            { "PT", metaValue_PT },
            { "PW", metaValue_PW },
            { "PY", "\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038" },
            { "QA", "\u1000\u102c\u1010\u102c" },
            { "QO", "\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c \u1021\u1015\u103c\u1004\u103a\u1018\u1000\u103a\u101b\u103e\u102d \u1000\u103b\u103d\u1014\u103a\u1038\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1019\u103b\u102c\u1038" },
            { "RE", "\u101b\u102e\u101a\u1030\u1014\u102e\u101a\u1014\u103a" },
            { "RO", "\u101b\u102d\u102f\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "RS", metaValue_RS },
            { "RU", "\u101b\u102f\u101b\u103e\u102c\u1038" },
            { "RW", "\u101b\u101d\u1014\u103a\u1012\u102b" },
            { "SA", "\u1006\u1031\u102c\u103a\u1012\u102e\u1021\u102c\u101b\u1031\u1038\u1018\u102e\u1038\u101a\u102c\u1038" },
            { "SB", "\u1006\u1031\u102c\u103a\u101c\u1019\u103d\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "SC", "\u1006\u1031\u1038\u101b\u103e\u1032" },
            { "SD", metaValue_SD },
            { "SE", metaValue_SE },
            { "SG", "\u1005\u1004\u103a\u1039\u1000\u102c\u1015\u1030" },
            { "SH", "\u1005\u102d\u1014\u1037\u103a\u101f\u101a\u103a\u101c\u101a\u103a\u1014\u102c" },
            { "SI", metaValue_SI },
            { "SJ", "\u1005\u1017\u102d\u102f\u101c\u103a\u1018\u1010\u103a\u1014\u103e\u1004\u1037\u103a\u1002\u103b\u1014\u103a\u1019\u1031\u101b\u1014\u103a" },
            { "SK", "\u1006\u101c\u102d\u102f\u1017\u1000\u103a\u1000\u102e\u1038\u101a\u102c\u1038" },
            { "SL", "\u1006\u102e\u101a\u102c\u101b\u102c \u101c\u102e\u101a\u103d\u1014\u103a\u1038" },
            { "SM", "\u1006\u1014\u103a\u1019\u102c\u101b\u102e\u1014\u102d\u102f" },
            { "SN", "\u1006\u102e\u1014\u102e\u1002\u1031\u102b" },
            { "SO", "\u1006\u102d\u102f\u1019\u102c\u101c\u102e\u101a\u102c" },
            { "SR", "\u1006\u1030\u101b\u102c\u1014\u1019\u103a" },
            { "SS", "\u1010\u1031\u102c\u1004\u103a \u1006\u1030\u1012\u1014\u103a" },
            { "ST", "\u1006\u1031\u102c\u1004\u103a\u1010\u1030\u1019\u1031\u1038\u1014\u103e\u1004\u1037\u103a \u1015\u101b\u1004\u103a\u1005\u102e\u1015\u102e" },
            { "SV", "\u1021\u101a\u103a\u101c\u103a\u1006\u102c\u1017\u1031\u1038\u1012\u102d\u102f\u1038" },
            { "SX", "\u1005\u1004\u1037\u103a\u1019\u102c\u1010\u1004\u103a" },
            { "SY", metaValue_SY },
            { "SZ", metaValue_SZ },
            { "TA", "\u1011\u101b\u1005\u1039\u1005\u1010\u1014\u103a \u1012\u102b \u1000\u103d\u1014\u103a\u101f\u102c" },
            { "TC", "\u1010\u1001\u103a\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1000\u102c\u1021\u102e\u1000\u102d\u102f\u1005\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "TD", "\u1001\u103b\u1012\u103a" },
            { "TF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a\u1019\u103b\u102c\u1038" },
            { "TG", "\u1010\u102d\u102f\u1002\u102d\u102f" },
            { "TH", metaValue_TH },
            { "TJ", "\u1010\u102c\u1002\u103b\u102e\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "TK", "\u1010\u102d\u102f\u1000\u101c\u1031\u102c\u1004\u103a" },
            { "TL", "\u1021\u101b\u103e\u1031\u1037\u1010\u102e\u1019\u1031\u102c" },
            { "TM", metaValue_TM },
            { "TN", "\u1010\u1030\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "\u1011\u101b\u102e\u1014\u102e\u1012\u1010\u103a\u1014\u103e\u1004\u1037\u103a \u1010\u102d\u102f\u1018\u1000\u103a\u1002\u102d\u102f" },
            { "TV", "\u1010\u1030\u1017\u102c\u1038\u101c\u1030" },
            { "TW", "\u1011\u102d\u102f\u1004\u103a\u101d\u1019\u103a" },
            { "TZ", "\u1010\u1014\u103a\u1007\u1014\u103a\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "UA", metaValue_UA },
            { "UG", "\u101a\u1030\u1002\u1014\u103a\u1038\u1012\u102b\u1038" },
            { "UM", "\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1005\u1010\u102d\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1019\u103b\u102c\u1038" },
            { "UN", "\u1000\u102f\u101c\u101e\u1019\u1002\u1039\u1002" },
            { "US", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f" },
            { "UY", "\u1025\u101b\u102f\u1002\u103d\u1031\u1038" },
            { "UZ", "\u1025\u1007\u1018\u1000\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "VA", "\u1017\u102c\u1010\u102e\u1000\u1014\u103a\u1005\u102e\u1038\u1010\u102e\u1038" },
            { "VC", "\u1005\u102d\u1014\u1037\u103a\u1017\u1004\u103a\u1038\u1006\u1004\u1037\u103a\u1014\u103e\u1004\u1037\u103a \u1002\u101b\u102d\u1014\u1031\u1012\u102d\u102f\u1004\u103a" },
            { "VE", "\u1017\u1004\u103a\u1014\u102e\u1007\u103d\u1032\u101c\u102c\u1038" },
            { "VG", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1017\u102c\u1002\u103b\u1004\u103a\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "VI", "\u101a\u1030\u1021\u1000\u103a\u1005\u103a \u1017\u102c\u1002\u103b\u1004\u103a\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "VN", metaValue_VN },
            { "VU", "\u1017\u1014\u103d\u102c\u1038\u1010\u1030" },
            { "WF", "\u101d\u1031\u102b\u101c\u1005\u103a\u1014\u103e\u1004\u1037\u103a \u1016\u1030\u1000\u103b\u1030\u1038\u1014\u102c\u1038" },
            { "WS", "\u1006\u1019\u102d\u102f\u1038\u1021\u102c\u1038" },
            { "XA", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1001\u103c\u102c\u1038\u101e\u1036" },
            { "XB", "\u1005\u102c\u1015\u103c\u1031\u102c\u1004\u103a\u1038\u1015\u103c\u1014\u103a" },
            { "XK", "\u1000\u102d\u102f\u1006\u102d\u102f\u1017\u102d\u102f" },
            { "YE", "\u101a\u102e\u1019\u1004\u103a" },
            { "YT", "\u1019\u1031\u101a\u1031\u102c\u1037" },
            { "ZA", "\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u1016\u101b\u102d\u1000" },
            { "ZM", "\u1007\u1019\u103a\u1018\u102e\u101a\u102c" },
            { "ZW", "\u1007\u1004\u103a\u1018\u102c\u1018\u103d\u1031" },
            { "ZZ", "\u1019\u101e\u102d (\u101e\u102d\u102f\u1037) \u1019\u101b\u103e\u102d\u101e\u1031\u102c \u1012\u1031\u101e" },
            { "aa", "\u1021\u102c\u1016\u102c" },
            { "ab", "\u1021\u1018\u103a\u1001\u102b\u1007\u102e\u101b\u102c" },
            { "af", "\u1021\u102c\u1016\u101b\u102d\u1000\u1014\u103a" },
            { "ak", "\u1021\u102c\u1000\u1014\u103a" },
            { "am", "\u1021\u1019\u103a\u101f\u102c\u101b\u1005\u103a\u1001\u103a" },
            { "an", "\u1021\u102c\u101b\u102c\u1002\u103d\u1014\u103a" },
            { "ar", "\u1021\u102c\u101b\u1017\u102e" },
            { "as", "\u1021\u102c\u101e\u1036" },
            { "av", "\u1021\u102c\u1017\u102c\u101b\u1005\u103a\u1001\u103a" },
            { "ay", "\u1021\u102d\u102f\u1004\u103a\u1019\u102c\u101b" },
            { "az", metaValue_AZ },
            { "ba", "\u1018\u1000\u103a\u101b\u103e\u103a\u1000\u102c" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "\u1018\u1005\u103a\u1005\u103a\u101c\u102c\u1019\u102c" },
            { "bm", "\u1018\u1014\u103a\u1018\u102c\u101b\u102c" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u1018\u101b\u102e\u1010\u103d\u1014\u103a" },
            { "bs", "\u1018\u1031\u102c\u1037\u1005\u103a\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "ca", "\u1000\u1010\u103a\u1010\u101c\u1014\u103a" },
            { "ce", "\u1001\u103b\u1000\u103a\u1001\u103b\u1014\u103a\u1038" },
            { "ch", "\u1001\u103b\u1019\u102d\u102f\u101b\u102d\u102f" },
            { "co", "\u1001\u102d\u102f\u1005\u102e\u1000\u1014\u103a" },
            { "cr", "\u1001\u101b\u102e\u1038" },
            { "cs", "\u1001\u103b\u1000\u103a" },
            { "cu", "\u1001\u103b\u1015\u103a\u1001\u103b\u103a \u1005\u101c\u102c\u1017\u1005\u103a" },
            { "cv", "\u1001\u103b\u1030\u1017\u1000\u103a\u101b\u103e\u103a" },
            { "cy", "\u101d\u1031\u101c" },
            { "da", metaValue_DK },
            { "de", "\u1002\u103b\u102c\u1019\u1014\u103a" },
            { "dv", "\u1012\u102e\u1017\u102c\u101f\u102e" },
            { "dz", "\u1012\u1007\u103d\u1014\u103a\u1000\u102c" },
            { "ee", "\u1021\u102e\u101d\u102e" },
            { "el", metaValue_GR },
            { "en", "\u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "eo", "\u1021\u1000\u103a\u1005\u103a\u1015\u101b\u1014\u103a\u1010\u102d\u102f" },
            { "es", metaValue_ES },
            { "et", "\u1021\u1000\u103a\u1005\u103a\u1010\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "eu", "\u1018\u102c\u1005\u103a\u1001\u103a" },
            { "fa", "\u1015\u102b\u101b\u103e\u1014\u103a" },
            { "ff", "\u1016\u1030\u101c\u102c" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fo", "\u1016\u102c\u101b\u102d\u102f" },
            { "fr", metaValue_FR },
            { "fy", "\u1021\u1014\u1031\u102c\u1000\u103a \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "ga", "\u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a\u101b\u103e\u103a" },
            { "gd", "\u1005\u1000\u1031\u102c\u1037\u1010\u1005\u103a\u101b\u103e\u103a \u1002\u1031\u1038\u101c\u1005\u103a\u1001\u103a" },
            { "gl", "\u1002\u102b\u101c\u102e\u1005\u102e\u101a\u102c" },
            { "gn", "\u1002\u1030\u1021\u102c\u101b\u102c\u1014\u102e" },
            { "gu", "\u1002\u1030\u1002\u103b\u102c\u101b\u101e\u102e" },
            { "gv", "\u1019\u1014\u103a\u1038\u1007\u103a" },
            { "ha", "\u101f\u102c\u1025\u1005\u102c" },
            { "he", "\u101f\u102e\u1018\u101b\u1030\u1038" },
            { "hi", "\u101f\u102d\u1014\u103a\u1012\u1030" },
            { "hr", metaValue_HR },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "\u101f\u102e\u101b\u1032\u101b\u102d\u102f" },
            { "ia", "\u1021\u1004\u103a\u1010\u102c\u101c\u1004\u103a\u1002\u103d\u102b" },
            { "id", metaValue_ID },
            { "ig", "\u1021\u1005\u1039\u1002\u1018\u102d\u102f" },
            { "ii", "\u1005\u102e\u1001\u103b\u103d\u1019\u103a \u101b\u102e" },
            { "io", "\u1021\u102e\u1012\u102d\u102f" },
            { "is", "\u1021\u102d\u102f\u1000\u103a\u1005\u103a\u101c\u1014\u103a" },
            { "it", metaValue_IT },
            { "iu", "\u1021\u102e\u1014\u102f\u1001\u103a\u1010\u102e\u1010\u102f" },
            { "ja", metaValue_JP },
            { "jv", "\u1002\u103b\u102c\u1017\u102c\u1038" },
            { "ka", metaValue_GE },
            { "kg", metaValue_CD },
            { "ki", "\u1000\u102e\u1000\u1030\u101a\u1030" },
            { "kj", "\u1000\u103d\u1014\u103a\u1038\u101a\u102c\u1019\u102c" },
            { "kk", "\u1000\u102c\u1007\u102c\u1001\u103b" },
            { "kl", "\u1000\u101c\u102c\u1021\u103a\u101c\u102e\u1006\u1015\u103a" },
            { "km", metaValue_km },
            { "kn", "\u1000\u1014\u103a\u1014\u102c\u1012\u102b" },
            { "ko", metaValue_ko },
            { "kr", "\u1000\u1014\u1030\u101b\u102e" },
            { "ks", "\u1000\u1000\u103a\u101b\u103e\u103a\u1019\u102e\u1038\u101a\u102c\u1038" },
            { "ku", "\u1000\u1012\u103a" },
            { "kv", "\u1000\u102d\u102f\u1019\u102e" },
            { "kw", "\u1001\u102d\u102f\u1014\u102e\u101b\u103e\u103a" },
            { "ky", "\u1000\u102c\u1002\u103b\u1005\u103a" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "\u1002\u1014\u103a\u1012\u102b" },
            { "li", "\u101c\u1004\u103a\u1018\u102c\u1002\u1005\u103a\u101b\u103e\u103a" },
            { "ln", "\u101c\u1004\u103a\u1002\u102b\u101c\u102c" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "\u101c\u1030\u1018\u102c-\u1000\u1010\u1014\u103a\u1002\u102b" },
            { "lv", metaValue_LV },
            { "mg", "\u1019\u102c\u101c\u1002\u1000\u103a\u1005\u102e" },
            { "mh", "\u1019\u102c\u101b\u103e\u101a\u103a\u101c\u102d\u1007\u103a" },
            { "mi", "\u1019\u102c\u1021\u102d\u102f\u101b\u102e" },
            { "mk", "\u1019\u1000\u103a\u1006\u102e\u1012\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u1019\u102c\u101b\u101e\u102e" },
            { "ms", "\u1019\u101c\u1031\u1038" },
            { "mt", "\u1019\u1031\u102c\u103a\u101c\u103a\u1010\u102c" },
            { "my", metaValue_MM },
            { "na", metaValue_NR },
            { "nb", "\u1014\u1031\u102c\u103a\u101d\u1031 \u1018\u103d\u1010\u103a\u1001\u103a\u1019\u1031\u102c\u103a\u101c\u103a" },
            { "nd", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u103d\u1014\u103a\u1014\u103a\u1012\u102e\u1018\u102e\u101c\u102e" },
            { "ne", metaValue_NP },
            { "ng", "\u1021\u103d\u1014\u103a\u1012\u103d\u1014\u103a\u1002\u102b" },
            { "nl", "\u1012\u1010\u103a\u1001\u103a\u103b" },
            { "nn", "\u1014\u1031\u102c\u103a\u101d\u1031 \u1014\u102e\u1038\u1014\u1031\u102c\u1005\u103a" },
            { "no", metaValue_NO },
            { "nr", "\u1010\u1031\u102c\u1004\u103a \u1021\u103d\u1014\u103a\u1014\u103a\u1018\u102e\u101c\u102e" },
            { "nv", "\u1014\u102c\u1017\u102c\u101f\u102d\u102f" },
            { "ny", "\u1014\u101b\u1014\u103a\u1002\u103b\u102c" },
            { "oc", "\u1021\u102d\u102f\u1005\u102e\u1010\u1014\u103a" },
            { "om", "\u1021\u102d\u102f\u101b\u102d\u102f\u1019\u102d\u102f" },
            { "or", "\u1021\u102d\u102f\u101b\u102e\u101b\u102c" },
            { "os", "\u1021\u102d\u102f\u1006\u1032\u1010\u1005\u103a\u1001\u103a" },
            { "pa", "\u1015\u1014\u103a\u1001\u103b\u102c\u1015\u102e" },
            { "pi", "\u1015\u102b\u1020\u102d" },
            { "pl", metaValue_PL },
            { "ps", "\u1015\u1000\u103a\u101b\u103e\u103a\u1010\u103d\u1014\u103a\u1038" },
            { "pt", metaValue_PT },
            { "qu", "\u1001\u102e\u1001\u103b\u1030\u101d\u102b\u1021\u102d\u102f\u101d\u102b" },
            { "rm", "\u101b\u1031\u102c\u1019" },
            { "rn", "\u101b\u103d\u1014\u103a\u1012\u102e" },
            { "ro", "\u101b\u102d\u102f\u1019\u1031\u1014\u102e\u101a\u102c\u1038" },
            { "ru", "\u101b\u102f\u101b\u103e" },
            { "rw", "\u1000\u1004\u103a\u101b\u102c\u101d\u1014\u103a\u1012\u102b" },
            { "sa", "\u101e\u1004\u103a\u1039\u101e\u1000\u101b\u102d\u102f\u1000\u103a" },
            { "sc", "\u1006\u102c\u1012\u102e\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "sd", "\u1005\u1004\u103a\u1012\u102e" },
            { "se", "\u1019\u103c\u1031\u102c\u1000\u103a \u1006\u102c\u1019\u102d" },
            { "sg", "\u1006\u1014\u103a\u1002\u102d\u102f" },
            { "si", "\u1005\u1004\u103a\u101f\u102c\u101c\u102c" },
            { "sk", "\u1006\u101c\u102d\u102f\u1017\u1000\u103a" },
            { "sl", metaValue_SI },
            { "sm", "\u1006\u1019\u102d\u102f\u1021\u102c" },
            { "sn", "\u101b\u103e\u102d\u102f\u1014\u102c" },
            { "so", "\u1006\u102d\u102f\u1019\u102c\u101c\u102e" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", metaValue_SZ },
            { "st", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1006\u102d\u102f\u101e\u102d\u102f" },
            { "su", metaValue_SD },
            { "sv", metaValue_SE },
            { "sw", "\u1006\u103d\u102c\u101f\u102e\u101c\u102e" },
            { "ta", metaValue_ta },
            { "te", "\u1010\u102e\u101c\u102e\u1002\u1030" },
            { "tg", "\u1010\u102c\u1002\u103b\u1005\u103a" },
            { "th", metaValue_TH },
            { "ti", "\u1010\u102e\u1002\u103a\u101b\u1004\u103a\u101a\u102c" },
            { "tk", metaValue_TM },
            { "tn", "\u1010\u102e\u1006\u101d\u102b\u1014\u102c" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "\u1006\u103d\u1014\u103a\u1002\u102b" },
            { "tt", "\u1010\u102c\u1010\u102c" },
            { "ty", "\u1010\u101f\u102e\u1010\u102e" },
            { "ug", "\u101d\u102e\u1002\u102b" },
            { "uk", metaValue_UA },
            { "ur", "\u1021\u1030\u101b\u103a\u1012\u1030" },
            { "uz", "\u1025\u1007\u1018\u1010\u103a" },
            { "ve", "\u1017\u1004\u103a\u1014\u103a\u1012\u102b" },
            { "vi", metaValue_VN },
            { "vo", "\u1017\u102d\u102f\u101c\u102c\u1015\u102d\u102f\u1000\u103a" },
            { "wa", "\u101d\u102b\u101c\u1030\u1038\u1014\u103a" },
            { "wo", "\u101d\u1030\u101c\u102d\u102f\u1016\u103a" },
            { "xh", "\u1007\u102d\u102f\u1005\u102c" },
            { "yi", "\u101b\u101f\u1030\u1012\u102e" },
            { "yo", "\u101a\u102d\u102f\u101b\u1030\u1018\u102c" },
            { "zh", metaValue_CN },
            { "zu", "\u1007\u1030\u1038\u101c\u1030\u1038" },
            { "ace", "\u1021\u102c\u1001\u103b\u1031\u1038" },
            { "ada", "\u1012\u1014\u103a\u1019\u1032" },
            { "ady", "\u1021\u1012\u102d\u102f\u1004\u103a\u1002\u102e" },
            { "agq", "\u1021\u102c\u1002\u103a\u101f\u102d\u1014\u103a\u1038" },
            { "ain", "\u1021\u102d\u1014\u103a\u1014\u102f" },
            { "ale", "\u1021\u102c\u101c\u102e\u101a\u102f" },
            { "alt", "\u1010\u1031\u102c\u1004\u103a \u1021\u102c\u101c\u103a\u1010\u102d\u102f\u1004\u103a\u1038" },
            { "ang", "\u1021\u1004\u103a\u1002\u101c\u102d\u102f \u1006\u1000\u1039\u1000\u1005\u103d\u1014\u103a" },
            { "ann", "\u1021\u102d\u102f\u1018\u102d\u102f\u101c\u102d\u102f" },
            { "anp", "\u1021\u1014\u103a\u1002\u102e\u1000\u102c" },
            { "arn", "\u1019\u102c\u1015\u102f\u1001\u103b\u102e" },
            { "arp", "\u1021\u102c\u101b\u102c\u1015\u102b\u101f\u102d\u102f" },
            { "ars", "\u1014\u102c\u1037\u1002\u103b\u1012\u102e \u1021\u102c\u101b\u1017\u1005\u103a" },
            { "asa", "\u1021\u102c\u1005\u102f" },
            { "ast", "\u1021\u1000\u103a\u1005\u103a\u1010\u102d\u102f\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "atj", "\u1021\u102c\u1010\u102e\u1000\u1019\u1032\u1000\u102f" },
            { "awa", "\u1021\u102c\u101d\u102b\u1012\u102e" },
            { "ban", "\u1018\u102c\u101c\u102e" },
            { "bas", "\u1018\u102c\u1006\u102c" },
            { "bem", "\u1018\u102d\u1014\u103a\u1018\u102c" },
            { "bez", "\u1018\u102e\u1014\u102c" },
            { "bgc", "\u101f\u102c\u101a\u1014\u103a\u1017\u102e" },
            { "bgn", "\u1021\u1014\u1031\u102c\u1000\u103a \u1018\u1032\u101c\u102d\u102f\u1001\u103b\u102e" },
            { "bho", "\u1018\u102d\u102f\u1037\u1002\u103b\u103a\u1015\u1030\u101b\u102e" },
            { "bin", "\u1018\u102e\u1014\u102e" },
            { "bla", "\u1005\u1005\u1039\u1005\u102e\u1000\u102c" },
            { "brx", "\u1017\u102d\u102f\u1012\u102d\u102f" },
            { "bug", "\u1018\u1030\u1002\u1005\u103a\u1005\u103a" },
            { "byn", "\u1018\u101c\u1004\u103a" },
            { "cay", "\u1000\u102c\u101a\u102f\u1002\u102b" },
            { "ccp", "\u1001\u103b\u1010\u103a\u1001\u103a\u1019\u102c" },
            { "ceb", "\u1005\u102e\u1017\u1030\u1021\u102c\u1014\u102d\u102f" },
            { "cgg", "\u1001\u103b\u102e\u1002\u102b" },
            { "chk", "\u1001\u103b\u1030\u1000\u102e\u1038\u1005\u103a" },
            { "chm", "\u1019\u102c\u101b\u102e" },
            { "cho", "\u1001\u103b\u1031\u102c\u1037\u1010\u102d\u102f" },
            { "chp", "\u1001\u103b\u102e\u1015\u103d\u1031\u101d\u102d\u102f\u1004\u103a\u101b\u1014\u103a" },
            { "chr", "\u1001\u103b\u102c\u101b\u102d\u102f\u1000\u102e" },
            { "chy", "\u1001\u103b\u1031\u101a\u1014\u103a\u1038" },
            { "ckb", "\u1017\u101f\u102d\u102f\u1012\u1031\u101e\u101e\u102f\u1036\u1038 \u1000\u1012\u103a\u1018\u102c\u101e\u102c" },
            { "clc", "\u1001\u103b\u102e\u1000\u102d\u102f\u101c\u103a\u1010\u1004\u103a" },
            { "crg", "\u1019\u1005\u103a\u1001\u103b\u1005\u103a\u1001\u103a" },
            { "crj", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u101b\u103e\u1031\u1037\u1001\u101b\u102e" },
            { "crk", "\u1015\u101c\u102d\u1014\u103a\u1038\u1005\u103a \u1001\u101b\u102e" },
            { "crl", "\u1019\u103c\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u101b\u103e\u1031\u1037\u1001\u101b\u102e" },
            { "crm", "\u1019\u102f\u1005\u103a\u1001\u101b\u102e\u1038" },
            { "crr", "\u1000\u101a\u103a\u101b\u102d\u102f\u101c\u102d\u102f\u1004\u103a\u1038\u1014\u102c\u1038 \u1021\u101a\u103a\u101c\u103a\u1002\u103d\u1014\u103a\u1038\u1000\u102e\u101a\u1014\u103a" },
            { "crs", "\u1001\u101b\u102e\u1021\u102d\u102f\u101c\u102e" },
            { "csw", "\u1006\u103d\u1019\u103a\u1015\u102e \u1001\u101b\u102e" },
            { "dak", "\u1012\u102b\u1000\u102d\u102f\u1010\u102c" },
            { "dar", "\u1012\u102b\u1002\u103a\u101d\u102b" },
            { "dav", "\u1010\u102d\u102f\u1004\u103a\u1010\u102c" },
            { "del", "\u1012\u101a\u103a\u101c\u102c\u101d\u1032\u101c\u103a" },
            { "dgr", "\u1012\u1031\u102b\u1037\u1002\u103a\u101b\u1005\u103a\u1018\u103a" },
            { "dje", "\u1007\u102c\u1019\u102c" },
            { "doi", "\u1012\u102d\u102f\u1002\u101b\u102e" },
            { "dsb", "\u1021\u1014\u102d\u1019\u1037\u103a \u1006\u102d\u102f\u1018\u102e\u101a\u1014\u103a\u1038" },
            { "dua", "\u1012\u1030\u1021\u101c\u102c" },
            { "dum", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1012\u1010\u103a\u1001\u103b\u103a" },
            { "dyo", "\u1002\u103b\u102d\u102f\u101c\u102c-\u1016\u103d\u1014\u103a\u101b\u102e" },
            { "dzg", "\u1012\u1007\u102c\u1002\u102b" },
            { "ebu", "\u1021\u1019\u103a\u1018\u1030" },
            { "efi", "\u1021\u102c\u1016\u102d\u1001\u103a" },
            { "egy", "\u101b\u103e\u1031\u1038\u101f\u1031\u102c\u1004\u103a\u1038 \u1021\u102e\u1002\u103b\u1005\u103a" },
            { "eka", "\u1021\u102e\u1000\u102c\u1002\u103b\u102f\u1001\u103a" },
            { "enm", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "ewo", "\u1021\u102e\u101d\u1014\u103a\u1012\u102d\u102f" },
            { "fil", metaValue_PH },
            { "fon", "\u1016\u1031\u102c\u103a\u1014\u103a" },
            { "frc", "\u1000\u1031\u1002\u103b\u1014\u103a \u1016\u101b\u1014\u1037\u103a\u1005\u103a" },
            { "frm", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "fro", "\u1016\u101b\u1014\u103a\u1005\u102e\u1005\u103a" },
            { "frr", "\u1019\u103c\u1031\u102c\u1000\u103a \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "frs", "\u1021\u101b\u103e\u1031\u1037 \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "fur", "\u1016\u101b\u1030\u101c\u102e\u101a\u1014\u103a\u1038" },
            { "gaa", "\u1002\u102b" },
            { "gag", "\u1002\u102b\u1002\u102f\u1007\u103a" },
            { "gez", "\u1002\u102e\u1038\u1007\u103a" },
            { "gil", "\u1000\u102c\u101b\u102e\u1017\u102c\u1010\u102e" },
            { "gmh", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u103c\u1004\u1037\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "gor", "\u1002\u102d\u102f\u101b\u102d\u102f\u1010\u102c\u101c\u102d\u102f" },
            { "grc", "\u101b\u103e\u1031\u1038\u101f\u1031\u102c\u1004\u103a\u1038 \u1002\u101b\u102d" },
            { "gsw", "\u1006\u103d\u1005\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "guz", "\u1002\u1030\u1005\u102e\u1038" },
            { "gwi", "\u1002\u103d\u1005\u103a\u1001\u103b\u1004\u103a" },
            { "hai", "\u101f\u1031\u1012\u102b" },
            { "haw", "\u101f\u102c\u101d\u102d\u102f\u1004\u103a\u101a\u102e" },
            { "hax", "\u1010\u1031\u102c\u1004\u103a \u101f\u102d\u102f\u1004\u103a\u1012\u102b" },
            { "hil", "\u101f\u102e\u101c\u102e\u1002\u1031\u1014\u103d\u1014\u103a" },
            { "hmn", "\u1019\u102f\u1036" },
            { "hsb", "\u1006\u1000\u1039\u1000\u1006\u102d\u102f\u1014\u102e" },
            { "hup", "\u101f\u1030\u1015\u102b" },
            { "hur", "\u101f\u1031\u102c\u1037\u1000\u1019\u102d\u102f\u101c\u103d\u1019\u103a" },
            { "iba", "\u1021\u102e\u1017\u1014\u103a" },
            { "ibb", "\u1021\u102e\u1018\u102e\u1018\u102e\u101a\u102d\u102f" },
            { "ikt", "\u1021\u1014\u1031\u102c\u1000\u103a \u1000\u1014\u1031\u1012\u102e\u101a\u1014\u103a \u1021\u102e\u1014\u102f\u1010\u102e\u1010\u103d\u1010\u103a" },
            { "ilo", "\u1021\u102e\u101c\u102d\u102f\u1000\u102d\u102f" },
            { "inh", "\u1021\u1004\u103a\u1002\u102f\u101b\u103e\u103a" },
            { "jbo", "\u101c\u102d\u102f\u1002\u103b\u103a\u1018\u1014\u103a" },
            { "jgo", "\u1002\u103d\u1019\u103a\u1018\u102c" },
            { "jmc", "\u1019\u1001\u103b\u102c\u1019\u102e" },
            { "jpr", "\u1002\u103b\u1030\u1012\u102e\u101a\u102d\u102f-\u1015\u102b\u101b\u103e\u1014\u103a" },
            { "jrb", "\u1002\u103b\u1030\u1012\u102e\u101a\u102d\u102f-\u1021\u102c\u101b\u1017\u102e" },
            { "kab", "\u1000\u1018\u102d\u102f\u1004\u103a\u101c\u103a" },
            { "kac", "\u1000\u1001\u103b\u1004\u103a" },
            { "kaj", "\u1002\u103b\u1030\u1021\u1030" },
            { "kam", "\u1000\u1019\u103a\u1018\u102c" },
            { "kbd", "\u1000\u1018\u102c\u1012\u1004\u103a" },
            { "kcg", "\u1010\u102d\u102f\u1004\u103a\u1021\u1015\u103a" },
            { "kde", "\u1019\u102c\u1001\u103d\u1014\u103a\u1012\u102e" },
            { "kea", "\u1000\u1018\u1030\u1017\u102c\u1012\u102e\u1021\u102c\u1014\u1030" },
            { "kfo", "\u1000\u102d\u102f\u101b\u102d\u102f" },
            { "kgp", "\u1000\u102d\u1014\u103a\u1038\u1002\u1014\u103a" },
            { "kha", "\u1001\u102b\u1005\u102e" },
            { "khq", "\u1000\u102d\u102f\u101b\u102c \u1001\u103b\u102e\u1021\u102e\u1014\u102e" },
            { "kkj", "\u1000\u1000\u102d\u102f" },
            { "kln", "\u1000\u101c\u1014\u103a\u1002\u103b\u1004\u103a" },
            { "kmb", "\u1000\u1004\u103a\u1018\u103d\u1014\u103a\u1012\u1030" },
            { "koi", "\u1000\u102d\u102f\u1019\u102e-\u1015\u102b\u1019\u103c\u1000\u103a" },
            { "kok", "\u1000\u103d\u1014\u103a\u1000\u1014\u102e" },
            { "kpe", "\u1000\u1015\u103a\u1015\u1032\u101c\u103a" },
            { "krc", "\u1000\u101b\u102c\u1001\u103b\u1031\u1038-\u1018\u102c\u1000\u102c" },
            { "krl", "\u1000\u102c\u101b\u102e\u101c\u102e\u101a\u1014\u103a" },
            { "kru", "\u1000\u1030\u101b\u102f\u1015\u103a\u1001\u103a" },
            { "ksb", "\u101b\u103e\u1014\u103a\u1018\u102c\u101c\u102c" },
            { "ksf", "\u1018\u102c\u1016\u102e\u1021\u102c" },
            { "ksh", "\u1000\u102d\u102f\u101c\u102d\u102f\u1014\u102e\u101a\u1014\u103a\u1038" },
            { "kum", "\u1000\u103d\u1019\u103a\u1019\u102d\u102f\u1000\u103a" },
            { "kwk", "\u1000\u103d\u1015\u103a\u1001\u103a\u101d\u102b\u101c\u102c" },
            { "lad", "\u101c\u102c\u1012\u102e\u1014\u102d\u102f" },
            { "lag", "\u101c\u1014\u103a\u1002\u102e" },
            { "lez", "\u101c\u1000\u103a\u1007\u103a\u1002\u102e\u1038\u101a\u102c\u1038" },
            { "lil", "\u101c\u102c\u101c\u1030\u1038\u101d\u1005\u103a\u1010\u103a" },
            { "lkt", "\u101c\u102c\u1000\u102d\u102f\u1010\u102c" },
            { "lou", "\u101c\u1030\u101d\u102e\u1007\u102e\u101a\u102c\u1038\u1014\u102c\u1038 \u1001\u101b\u102e\u1038\u101a\u102d\u102f" },
            { "loz", "\u101c\u102d\u102f\u1007\u102e" },
            { "lrc", "\u1019\u103c\u1031\u102c\u1000\u103a\u101c\u1030\u101b\u102e" },
            { "lsm", "\u1006\u102c\u1019\u102d\u1021\u102c" },
            { "lua", "\u101c\u1030\u1018\u102c-\u101c\u1030\u101c\u1030\u1021\u102c" },
            { "lun", "\u101c\u103d\u1014\u103a\u1012\u102b" },
            { "luo", "\u101c\u1030\u1021\u102d\u102f" },
            { "lus", "\u1019\u102e\u1007\u102d\u102f" },
            { "luy", "\u101c\u1030\u101b\u102e\u1021\u102c" },
            { "mad", "\u1019\u1012\u1030\u101b\u102c" },
            { "mag", "\u1019\u1002\u102b\u101f\u102e" },
            { "mai", "\u1019\u102d\u102f\u1004\u103a\u101e\u102e\u101c\u102e" },
            { "mak", "\u1019\u1000\u102c\u1006\u102c" },
            { "mas", "\u1019\u102c\u1006\u102d\u102f\u1004\u103a" },
            { "mdf", "\u1019\u102d\u102f\u1037\u1001\u103a\u101b\u103e\u102c" },
            { "men", "\u1019\u1014\u103a\u1012\u1032" },
            { "mer", "\u1019\u102e\u101b\u102f" },
            { "mfe", metaValue_MU },
            { "mga", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a\u101b\u103e\u103a" },
            { "mgh", "\u1019\u102c\u1001\u1030\u101d\u102b-\u1019\u102e\u1021\u102e\u1010\u102d\u102f" },
            { "mgo", "\u1019\u102e\u1010\u102c" },
            { "mic", "\u1019\u1005\u103a\u1001\u103a\u1019\u1000\u103a\u1001\u103a" },
            { "min", "\u1005\u1030\u1000\u1030\u1019\u102e\u1014\u1014\u103a" },
            { "mnc", "\u1019\u1014\u103a\u1001\u103b\u1030\u1038" },
            { "mni", "\u1019\u1014\u102d\u1015\u1030\u101b" },
            { "moe", "\u1021\u102e\u1014\u102f\u1021\u1031\u1019\u103d\u1014\u103a" },
            { "moh", "\u1019\u102d\u102f\u101f\u1031\u102c\u1037\u1001\u103a" },
            { "mos", "\u1019\u102d\u102f\u1005\u102e" },
            { "mua", "\u1019\u103d\u1014\u103a\u1012\u1014\u103a\u1038" },
            { "mul", "\u1018\u102c\u101e\u102c\u1005\u1000\u102c\u1038 \u1021\u1019\u103b\u102d\u102f\u1038\u1019\u103b\u102d\u102f\u1038" },
            { "mus", "\u1001\u101b\u102d\u1001\u103b" },
            { "mwl", "\u1019\u102e\u101b\u1014\u103a\u1012\u102e\u1038\u1007\u103a" },
            { "myv", "\u1021\u102e\u1007\u101a\u102c" },
            { "mzn", "\u1019\u102c\u1007\u1014\u103a\u1012\u102b\u101b\u1014\u103a\u1014\u102e" },
            { "nap", "\u1014\u1015\u102d\u102f\u101c\u102e\u1010\u1014\u103a" },
            { "naq", "\u1014\u102c\u1019\u102c" },
            { "nds", "\u1021\u1014\u102d\u1019\u1037\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "new", "\u1014\u102e\u101d\u102b\u101b\u102e" },
            { "nia", "\u1014\u102e\u1038\u101b\u1015\u103a\u1005\u103a" },
            { "niu", "\u1014\u1030\u1021\u1032\u101a\u1014\u103a\u1038" },
            { "nmg", "\u1000\u103d\u102c\u1005\u102e\u1021\u102d\u102f" },
            { "nnh", "\u1021\u103d\u1014\u103a\u101b\u1032\u1018\u103d\u1014\u103a\u1038" },
            { "nog", "\u1014\u102d\u102f\u1002\u102d\u102f\u1004\u103a" },
            { "nqo", metaValue_nqo },
            { "nso", "\u1019\u103c\u1031\u102c\u1000\u103a \u1006\u102d\u102f\u101e\u102d\u102f" },
            { "nus", "\u1014\u1030\u1021\u102c" },
            { "nyn", "\u1014\u101b\u1014\u103a\u1000\u102d\u102f\u101c\u102e" },
            { "ojb", "\u1021\u102d\u102f\u1002\u103b\u1005\u103a\u1018\u103d\u102c" },
            { "ojc", "\u1021\u102d\u102f\u1002\u103b\u1005\u103a\u1018\u103d\u1031\u1038" },
            { "ojs", "\u1021\u102d\u102f\u1002\u103b\u102e\u1001\u101b\u102e" },
            { "ojw", "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102d\u102f\u1002\u103b\u102e\u1018\u103d\u102c" },
            { "oka", "\u1021\u102d\u102f\u1000\u1014\u1002\u1014\u103a" },
            { "pag", "\u1015\u1014\u103a\u1002\u102b\u1005\u102e\u1014\u1014\u103a" },
            { "pam", "\u1015\u1019\u103a\u1015\u1014\u103a\u100a\u102c" },
            { "pap", "\u1015\u102b\u1015\u102e\u1019\u1004\u103a\u1010\u102d\u102f" },
            { "pau", metaValue_PW },
            { "pcm", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1015\u1005\u103a\u1002\u103b\u1004\u103a" },
            { "peo", metaValue_peo },
            { "pis", "\u1015\u102e\u1002\u103b\u1004\u103a" },
            { "pqm", "\u1019\u101c\u102d\u1007\u102d \u1015\u102b\u1005\u1019\u103a\u1019\u1000\u103d\u102c\u1012\u102e" },
            { "prg", "\u1015\u101b\u1030\u101b\u103e\u1014\u103a" },
            { "quc", "\u1000\u102e\u1001\u103a\u1021\u102e\u1001\u103b\u102e" },
            { "raj", "\u101b\u102c\u1002\u103b\u102c\u1005\u1010\u102c\u1014\u102e" },
            { "rap", "\u101b\u1015\u1014\u103a\u1014\u1030\u1021\u102e" },
            { "rar", "\u101b\u101b\u102d\u102f\u1010\u103d\u1014\u103a\u1002\u1014\u103a" },
            { "rhg", "\u101b\u102d\u102f\u101f\u1004\u103a\u1002\u103b\u102c" },
            { "rof", "\u101b\u103d\u1019\u103a\u1018\u102d\u102f" },
            { "rup", "\u1021\u102c\u101b\u102d\u102f\u1019\u1014\u103a\u1038\u1014\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "rwk", "\u101b\u1030\u101d\u1019\u103a" },
            { "sad", "\u1006\u1014\u103a\u1012\u102b\u101d\u102e" },
            { "sah", "\u1006\u1001\u102b" },
            { "saq", "\u1006\u1019\u103a\u1018\u1030\u101b\u1030" },
            { "sat", "\u1006\u1014\u103a\u1010\u102c\u101c\u102e" },
            { "sba", "\u1021\u103d\u1014\u103a\u1002\u1019\u103a\u1038\u1018\u1031\u1038" },
            { "sbp", "\u1006\u1014\u103a\u1002\u102f" },
            { "scn", "\u1005\u1005\u1039\u1005\u101c\u102e" },
            { "sco", "\u1005\u1000\u1031\u102c\u1037\u1010\u103a" },
            { "seh", "\u1005\u102e\u1014\u102c" },
            { "ses", "\u1000\u102d\u102f\u101b\u102c\u1018\u102d\u102f\u101b\u102d\u102f \u1006\u1019\u103a\u1014\u102e" },
            { "sga", "\u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a \u101f\u1031\u102c\u1004\u103a\u1038" },
            { "shi", "\u1010\u102c\u1001\u103b\u101a\u103a\u101c\u103a\u101f\u1005\u103a" },
            { "shn", "\u101b\u103e\u1019\u103a\u1038" },
            { "slh", "\u1010\u1031\u102c\u1004\u103a \u101c\u102c\u1037\u101b\u103e\u102f\u1005\u1010\u102d" },
            { "sma", "\u1010\u1031\u102c\u1004\u103a \u1006\u102c\u1019\u102d" },
            { "smj", "\u101c\u1030\u101c\u102e \u1006\u102c\u1019\u102d" },
            { "smn", "\u1021\u102e\u1014\u102c\u101b\u102e \u1006\u102c\u1019\u102d" },
            { "sms", "\u1005\u1001\u102d\u102f\u1038\u101c\u103a \u1006\u102c\u1019\u102d" },
            { "snk", "\u1006\u102d\u102f\u1014\u1004\u103a\u1000\u1031\u1038" },
            { "srn", "\u1006\u101b\u102c\u1014\u1014\u103a \u1010\u103d\u1014\u103a\u1002\u102d\u102f" },
            { "ssy", "\u1006\u102c\u101f\u102d\u102f" },
            { "str", "\u1006\u1032\u101c\u1005\u103a\u101b\u103e\u103a \u101b\u1031\u101c\u1000\u103a\u1000\u103c\u102c\u1038" },
            { "suk", "\u1006\u1030\u1000\u1030\u1019\u102c" },
            { "swb", "\u1000\u102d\u102f\u1019\u102d\u102f\u101b\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "syr", metaValue_SY },
            { "tce", "\u1010\u1031\u102c\u1004\u103a \u1010\u1015\u103a\u1001\u103b\u103d\u1014\u103a" },
            { "tem", "\u1010\u1004\u103a\u1019\u103a\u1014\u1032" },
            { "teo", "\u1010\u102e\u1006\u102d\u102f" },
            { "tet", "\u1010\u102e\u1010\u103d\u1019\u103a" },
            { "tgx", "\u1010\u102c\u1002\u1005\u103a\u101b\u103e\u103a" },
            { "tht", "\u1010\u101f\u102e\u1010\u1014\u103a" },
            { "tig", "\u1010\u102e\u1002\u101b\u102e" },
            { "tlh", "\u1000\u101c\u1004\u103a\u1002\u103d\u1014\u103a" },
            { "tli", "\u1010\u101c\u1004\u103a\u1038\u1002\u1005\u103a" },
            { "tok", "\u1010\u102d\u102f\u1000\u102e\u1015\u102d\u102f\u1014\u102c" },
            { "tpi", "\u1010\u1031\u102c\u1037\u1001\u103a \u1015\u102d\u1005\u1004\u103a" },
            { "trv", "\u1010\u101b\u102d\u102f\u1000\u102d\u102f" },
            { "ttm", "\u1019\u103c\u1031\u102c\u1000\u103a \u1010\u1015\u103a\u1001\u103b\u103d\u1014\u103a" },
            { "tum", "\u1010\u1019\u103a\u1018\u1030\u1000\u102c" },
            { "tvl", "\u1010\u1030\u1017\u102c\u101c\u1030" },
            { "twq", "\u1010\u102c\u1006\u102c\u101d\u102b\u1001\u103b" },
            { "tyv", "\u1010\u1030\u1017\u1014\u103a" },
            { "tzm", "\u1021\u101c\u101a\u103a\u1021\u102c\u1037\u1010\u101c\u102c\u1005\u103a \u1010\u102c\u1019\u102c\u1007\u102d\u102f\u1000\u103a" },
            { "udm", "\u1021\u1030\u1019\u1030\u101b\u1010\u103a" },
            { "umb", "\u1021\u1030\u1018\u1014\u103a\u1012\u1030" },
            { "und", "\u1019\u101e\u102d\u101e\u1031\u102c \u1018\u102c\u101e\u102c" },
            { "vai", "\u1017\u102d\u102f\u1004\u103a" },
            { "vun", "\u1017\u103d\u1014\u103a\u1002\u103b\u102d\u102f" },
            { "wae", "\u101d\u1031\u102b\u101c\u103a\u1006\u102c" },
            { "wal", "\u101d\u102d\u102f\u101c\u1000\u103a\u1010\u102c" },
            { "war", "\u101d\u102b\u101b\u1031\u1038" },
            { "wbp", "\u101d\u1031\u102b\u101c\u103a\u1015\u102e\u101b\u102e" },
            { "wuu", "\u101d\u1030 \u1010\u101b\u102f\u1010\u103a" },
            { "xal", "\u1000\u102c\u101c\u103a\u1019\u102d\u102f\u1000\u103a" },
            { "xog", "\u1006\u102d\u102f\u1002\u102b" },
            { "yav", "\u101b\u1014\u103a\u1018\u1032\u1014\u103a" },
            { "ybb", "\u101b\u1019\u103a\u1018\u102c" },
            { "yrl", "\u1021\u1014\u103a\u101f\u1004\u103a\u1038\u1002\u1010\u1030" },
            { "yue", "\u1000\u103d\u1019\u103a\u1038\u1010\u102f\u1036" },
            { "zgh", "\u1019\u102d\u102f\u101b\u102d\u102f\u1000\u102d\u102f \u1010\u1019\u1007\u102d\u102f\u1000\u103a" },
            { "zun", "\u1007\u1030\u1014\u102e" },
            { "zxx", "\u1018\u102c\u101e\u102c\u1005\u1000\u102c\u1038\u1014\u103e\u1004\u1037\u103a \u1015\u1010\u103a\u101e\u1000\u103a\u101e\u1031\u102c\u1021\u101b\u102c \u1019\u101b\u103e\u102d\u1015\u102b" },
            { "zza", "\u1007\u102c\u1007\u102c" },
            { "Adlm", "\u1021\u1000\u103a\u1012\u103a\u101c\u1019\u103a" },
            { "Arab", "\u1021\u102c\u101b\u1031\u1017\u103b" },
            { "Aran", "\u1014\u1000\u103a\u1005\u103a\u1010\u102c\u101c\u102d\u1001\u103a" },
            { "Armn", metaValue_AM },
            { "Beng", metaValue_bn },
            { "Bopo", "\u1018\u102d\u102f\u1015\u102d\u102f" },
            { "Brah", "\u1017\u103d\u101f\u103a\u1019\u1019\u102e" },
            { "Brai", "\u1018\u101b\u1031" },
            { "Cakm", "\u1001\u103b\u1015\u103a\u1001\u103a\u1019\u102c" },
            { "Cans", "\u1000\u1004\u103a\u1014\u103a\u1005\u103a" },
            { "Cher", "\u1001\u103b\u102c\u101b\u102d\u102f\u1000\u102e\u1038" },
            { "Cyrl", "\u1005\u1005\u103a\u101b\u102d\u101c\u1005\u103a" },
            { "Deva", "\u1012\u102e\u1017\u1014\u102c\u1002\u101b\u102e" },
            { "Ethi", metaValue_ET },
            { "Geor", metaValue_GE },
            { "Grek", metaValue_GR },
            { "Gujr", "\u1002\u102f\u1002\u103b\u102c\u101b\u101e\u102e" },
            { "Guru", "\u1002\u1030\u101b\u1030" },
            { "Hanb", "\u101f\u1014\u103a\u1018\u103a" },
            { "Hang", "\u101f\u1014\u103a\u1002\u1030\u1038\u101c\u103a" },
            { "Hani", "\u101f\u1014\u103a" },
            { "Hans", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038" },
            { "Hant", "\u101b\u102d\u102f\u1038\u101b\u102c" },
            { "Hebr", "\u101f\u102e\u1017\u101b\u1030\u1038" },
            { "Hira", "\u101f\u102e\u101b\u1002\u1014" },
            { "Hrkt", "\u1002\u103b\u1015\u1014\u103a \u1021\u1000\u1039\u1001\u101b\u102c" },
            { "Jamo", "\u1002\u103b\u1019\u102d\u102f" },
            { "Java", "\u1002\u103b\u102c\u1017\u102c\u1038\u1014\u102e\u1038\u1005\u103a" },
            { "Jpan", metaValue_JP },
            { "Kali", "\u1000\u101a\u102c\u1038\u101c\u102e" },
            { "Kana", "\u1001\u1010\u1001\u1014" },
            { "Khmr", metaValue_km },
            { "Knda", "\u1001\u1014\u103a\u1014\u102c\u1012\u102b" },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_LA },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "\u1019\u1031\u1010\u1032\u1019\u102c\u101a\u1000\u103a" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Olck", "\u1021\u102d\u102f\u101c\u103a\u1001\u103b\u102e\u1000\u102e" },
            { "Orya", "\u1021\u102d\u102f\u101b\u102c" },
            { "Rohg", "\u101f\u102c\u1014\u102e\u1016\u102e" },
            { "Sinh", "\u1006\u1004\u103a\u101f\u102c\u101c" },
            { "Sund", metaValue_SD },
            { "Syrc", "\u1006\u102e\u101b\u102e\u101b\u1000\u103a\u1001\u103a" },
            { "Tale", "\u1010\u102d\u102f\u1004\u103a\u101c\u102e" },
            { "Taml", metaValue_ta },
            { "Telu", "\u1010\u102e\u101c\u102f" },
            { "Tfng", "\u1010\u102e\u1016\u102e\u1014\u1031\u102c" },
            { "Tglg", "\u1010\u1002\u101c\u1031\u102c\u1037\u1002\u103a" },
            { "Thaa", "\u101e\u102c\u1021\u103a" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Vaii", "\u1017\u102d\u102f\u1004\u103a\u1038" },
            { "Visp", "\u1019\u103c\u1004\u103a\u1014\u102d\u102f\u1004\u103a\u101e\u1031\u102c \u1005\u1000\u102c\u1038" },
            { "Xpeo", metaValue_peo },
            { "Yiii", "\u101b\u102e" },
            { "Zmth", "\u1002\u100f\u1014\u103a\u1038\u101e\u1004\u103a\u1039\u1001\u103b\u102c" },
            { "Zsye", "\u1021\u102e\u1019\u102d\u102f\u1002\u103b\u102e" },
            { "Zsym", "\u101e\u1004\u103a\u1039\u1000\u1031\u1010" },
            { "Zxxx", "\u1011\u102f\u1036\u1038\u1010\u1019\u103a\u1038\u101e\u1016\u103d\u101a\u103a\u101c\u102d\u102f\u1000\u103a\u1014\u102c\u101c\u103b\u1000\u103a\u101b\u103e\u102d\u101e\u1031\u102c" },
            { "Zyyy", "\u1021\u1019\u103b\u102c\u1038\u1014\u103e\u1004\u1037\u103a\u101e\u1000\u103a\u1006\u102d\u102f\u1004\u103a\u101e\u1031\u102c" },
            { "Zzzz", "\u1019\u101e\u102d \u101e\u102d\u102f\u1037\u1019\u101f\u102f\u1010\u103a \u1019\u101b\u103e\u102d\u101e\u1031\u102c \u1005\u1000\u102c\u1038\u101c\u102f\u1036\u1038" },
            { "de_AT", "\u1029\u1005\u1010\u103c\u102e\u1038\u101a\u102c\u1038 \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "de_CH", "\u1021\u101c\u102e\u1019\u1032\u1014\u103a\u1014\u1005\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "en_AU", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "en_CA", "\u1000\u1014\u1031\u1012\u102b \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "en_GB", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "en_US", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "es_ES", "\u1005\u1015\u102d\u1014\u103a (\u1025\u101b\u1031\u102c\u1015)" },
            { "es_MX", "\u1005\u1015\u102d\u1014\u103a (\u1019\u1000\u1039\u1000\u1006\u102e\u1000\u102d\u102f)" },
            { "fa_AF", "\u1012\u102b\u101b\u102e" },
            { "fr_CA", "\u1000\u1014\u1031\u1012\u102b \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "fr_CH", "\u1006\u103d\u1005\u103a \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "nl_BE", "\u1016\u101c\u102e\u1019\u1005\u103a\u101b\u103e\u103a" },
            { "pt_BR", "\u1018\u101b\u102c\u1007\u102e\u1038 \u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e" },
            { "pt_PT", "\u1025\u101b\u1031\u102c\u1015 \u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e" },
            { "ro_MD", "\u1019\u1031\u102c\u103a\u101c\u1012\u102d\u102f\u1017\u102c" },
            { "sw_CD", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f \u1006\u103d\u102c\u101f\u102e\u101c\u102e" },
            { "%%1901", "\u101b\u103e\u1031\u1038\u101b\u102d\u102f\u1038\u1005\u1009\u103a\u101c\u102c \u1002\u103b\u102c\u1019\u1014\u103a \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "%%1996", "\u1041\u1049\u1049\u1046 \u1002\u103b\u102c\u1019\u1014\u103a \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "ar_001", "\u1001\u1031\u1010\u103a\u101e\u1005\u103a \u101b\u103e\u1031\u1037\u1006\u1031\u102c\u1004\u103a \u1021\u102c\u101b\u1017\u102e" },
            { "key.ca", "\u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "key.cf", "\u1004\u103d\u1031\u101b\u1031\u1010\u103d\u1000\u103a\u1015\u102f\u1036\u1005\u1014\u1005\u103a" },
            { "key.co", "\u1021\u1005\u1009\u103a\u101c\u102d\u102f\u1000\u103a\u1005\u102e\u101b\u1014\u103a" },
            { "key.cu", "\u1004\u103d\u1031\u1000\u103c\u1031\u1038" },
            { "key.hc", "\u1014\u102c\u101b\u102e\u1005\u1000\u103a\u101d\u1014\u103a\u1038 (\u1041\u1042 \u1014\u103e\u1004\u1037\u103a \u1042\u1044)" },
            { "key.lb", "\u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "key.ms", "\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u101b\u1031\u1038\u1005\u1014\u1005\u103a" },
            { "key.nu", "\u1000\u102d\u1014\u103a\u1038\u1002\u100f\u1014\u103a\u1038" },
            { "nds_NL", "\u1002\u103b\u102c\u1019\u1014\u103a (\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a)" },
            { "%%POSIX", "\u1000\u103d\u1014\u103a\u1015\u103b\u1030\u1010\u102c" },
            { "%%FONIPA", "IPA \u1021\u101e\u1036\u1011\u103d\u1000\u103a" },
            { "%%FONUPA", "UPA \u1021\u101e\u1036\u1011\u103d\u1000\u103a" },
            { "%%AREVELA", "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "%%REVISED", "\u1015\u103c\u1014\u103a\u101c\u100a\u103a\u1005\u102e\u1005\u1005\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "%%1606NICT", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1014\u1031\u102c\u1000\u103a\u1000\u103b\u101e\u1031\u102c\u1015\u103c\u1004\u103a\u101e\u1005\u103a\u1019\u103e \u1041\u1046\u1040\u1046" },
            { "%%1694ACAD", "\u1041\u1046\u1049\u1044ACAD" },
            { "%%BAKU1926", "\u1015\u1031\u102b\u1004\u103a\u1038\u1005\u1015\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u1010\u1030\u101b\u1000\u102e \u101c\u1000\u103a\u1010\u1004\u103a\u1005\u1000\u102c\u1038\u101c\u102f\u1036\u1038" },
            { "%%SCOTLAND", "\u1005\u1000\u1031\u102c\u1037 \u1005\u1036 \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "type.ca.roc", "\u1019\u1004\u103a\u1002\u102f\u1021\u102d\u102f \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.hc.h11", "\u1041\u1042 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a (\u1040\u2013\u1041\u1041)" },
            { "type.hc.h12", "\u1041\u1042 \u1014\u102c\u101b\u102e\u1005\u1014\u1005\u103a (\u1041\u2013\u1041\u1042)" },
            { "type.hc.h23", "\u1042\u1044 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a (\u1040\u2013\u1042\u1043)" },
            { "type.hc.h24", "\u1042\u1044 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a(\u1041\u2013\u1042\u1044)" },
            { "type.nu.arab", "\u1021\u102c\u101b\u1015\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.armn", "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.beng", "\u1018\u1004\u103a\u1039\u1002\u102b\u101c\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.cakm", "\u1001\u103b\u102c\u1037\u1001\u103a\u1019\u102c \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.deva", "\u1012\u102e\u1017\u102c\u1014\u102c\u1002\u101b\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.ethi", "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1015\u102e\u1038\u101a\u102c\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.geor", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1010\u1000\u102c\u101e\u102f\u1036\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.grek", "\u1002\u101b\u102d \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.gujr", "\u1002\u102f\u1002\u103b\u102c\u101b\u1010\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.guru", "\u1002\u1030\u1019\u1030\u1001\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hans", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038 \u1010\u101b\u102f\u1010\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hant", "\u101b\u102d\u102f\u1038\u101b\u102c \u1010\u101b\u102f\u1010\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hebr", "\u101f\u102e\u1018\u101b\u1030\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.java", "\u1002\u103b\u102c\u1017\u102c\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.jpan", "\u1002\u103b\u1015\u1014\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.khmr", "\u1001\u1019\u102c \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.knda", "\u1001\u1014\u1039\u1014\u1012\u102b \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.laoo", "\u101c\u102c\u1021\u102d\u102f \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.latn", "\u1021\u1014\u1031\u102c\u1000\u103a\u1010\u102d\u102f\u1004\u103a\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.mlym", "\u1019\u101c\u1031\u101a\u102c\u101c\u1019\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.mtei", "\u1019\u102e\u1010\u1032\u1019\u102c\u101a\u1005\u103a\u1001\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.mymr", "\u1019\u103c\u1014\u103a\u1019\u102c \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.olck", "\u1021\u102d\u102f\u101c\u103a\u1001\u103b\u102e\u1000\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.orya", "\u1029\u101b\u102e\u101b\u102c \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.taml", "\u101b\u102d\u102f\u1038\u101b\u102c \u1010\u1019\u102e\u1038\u101c\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.telu", "\u1010\u101c\u102f\u1002\u102f \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.thai", "\u1011\u102d\u102f\u1004\u103a\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.tibt", "\u1010\u102d\u1018\u1000\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.vaii", "\u1017\u102d\u102f\u1004\u103a\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.ca.dangi", "\u1012\u1014\u103a\u1038\u1002\u102d \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.co.ducet", "\u1021\u1005\u1009\u103a\u101c\u102d\u102f\u1000\u103a\u1005\u102e\u1011\u102c\u1038\u101e\u1031\u102c \u101a\u1030\u1014\u102e\u1000\u102f\u1010\u103a" },
            { "type.lb.loose", "\u1000\u1014\u1037\u103a\u101e\u1010\u103a\u1019\u1011\u102c\u1038\u101e\u1031\u102c \u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "type.nu.roman", "\u101b\u1031\u102c\u1019 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.ca.coptic", "\u1000\u102d\u102f\u1037\u1015\u103a\u1010\u1005\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.hebrew", "\u101f\u102e\u1018\u101b\u1030\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.indian", "\u1021\u102d\u1014\u1039\u1012\u103c\u102d\u101a \u1021\u1019\u103b\u102d\u102f\u1038\u101e\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.co.search", "\u101a\u1031\u1018\u102f\u101a\u103b\u101b\u103e\u102c\u1001\u103c\u1004\u103a\u1038" },
            { "type.lb.normal", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a\u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "type.lb.strict", "\u1000\u1014\u1037\u103a\u101e\u1010\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "type.ms.metric", "\u1019\u1000\u103a\u1011\u101b\u1005\u103a\u1005\u1014\u1005\u103a" },
            { "type.ca.chinese", "\u1010\u101b\u102f\u1010\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.islamic", "\u1021\u1005\u1039\u1005\u101c\u102c\u1019\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.iso8601", "ISO-8601 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.persian", "\u1015\u102b\u101b\u103e\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.cf.account", "\u1005\u102c\u101b\u1004\u103a\u1038\u1000\u102d\u102f\u1004\u103a\u101e\u102f\u1036\u1038 \u1004\u103d\u1031\u101b\u1031\u1010\u103d\u1000\u103a\u1015\u102f\u1036\u1005\u1014\u1005\u103a" },
            { "type.nu.arabext", "\u1010\u102d\u102f\u1038\u1001\u103b\u1032\u1037\u1021\u102c\u101b\u1015\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.armnlow", "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031 \u1005\u102c\u101c\u102f\u1036\u1038\u101e\u1031\u1038" },
            { "type.nu.greklow", "\u1002\u101b\u102d \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031 \u1005\u102c\u101c\u102f\u1036\u1038\u101e\u1031\u1038" },
            { "type.nu.hanidec", "\u1010\u101b\u102f\u1010\u103a \u1006\u101a\u103a\u101c\u102e\u1005\u1014\u1005\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hansfin", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038 \u1010\u101b\u102f\u1010\u103a \u1018\u100f\u1039\u100d\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hantfin", "\u101b\u102d\u102f\u1038\u101b\u102c \u1010\u101b\u102f\u1010\u103a \u1018\u100f\u1039\u100d\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.jpanfin", "\u1002\u103b\u1015\u1014\u103a \u1018\u100f\u1039\u100d\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.tamldec", "\u1010\u1019\u102e\u1038\u101c\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.ca.buddhist", "\u1017\u102f\u1012\u1039\u1013 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.ethiopic", "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.japanese", "\u1002\u103b\u1015\u1014\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.cf.standard", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a \u1004\u103d\u1031\u101b\u1031\u1010\u103d\u1000\u103a\u1015\u102f\u1036\u1005\u1014\u1005\u103a" },
            { "type.co.standard", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a\u1005\u102e\u1011\u102c\u1038\u101e\u1031\u102c" },
            { "type.ms.uksystem", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u1005\u1014\u1005\u103a" },
            { "type.ms.ussystem", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u1005\u1014\u1005\u103a" },
            { "type.nu.fullwide", "\u1017\u103c\u1000\u103a\u1015\u103c\u100a\u1037\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.mymrshan", "\u101b\u103e\u1019\u103a\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.romanlow", "\u101b\u1031\u102c\u1019 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031 \u1005\u102c\u101c\u102f\u1036\u1038\u101e\u1031\u1038" },
            { "type.ca.gregorian", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1010\u1000\u102c\u101e\u102f\u1036\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.co.phonebook", "\u1016\u102f\u1014\u103a\u1038\u1005\u102c\u1021\u102f\u1015\u103a \u1021\u1005\u102e\u1021\u1005\u1009\u103a" },
            { "ListKeyTypePattern", "{0}- {1}" },
            { "type.ca.islamic-civil", "\u1021\u1005\u1039\u1005\u101c\u102c\u1019\u103a\u1019\u1005\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "ListCompositionPattern", "{0}/ {1}" },
            { "type.ca.islamic-umalqura", "\u1021\u101a\u103a\u101c\u103a\u1000\u1030\u101b\u102c \u1021\u1005\u1039\u1005\u101c\u102c\u1019\u103a\u1019\u1005\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.ca.ethiopic-amete-alem", "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1015\u1005\u103a\u1001\u103a \u1021\u102c\u1019\u1032\u1010\u1032 \u1021\u102c\u101c\u1004\u103a\u1019\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
        };
        return data;
    }
}
