/*
 * Copyright (c) 2010, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.javadoc.internal.doclets.formats.html.markup;

import java.util.Locale;

import jdk.javadoc.internal.doclets.toolkit.util.Utils;

/**
 * Enum representing the names for HTML elements.
 *
 * @see <a href="https://html.spec.whatwg.org/multipage/syntax.html#syntax-tag-name">WhatWG: Tag Name</a>
 * @see <a href="https://www.w3.org/TR/html51/syntax.html#tag-name">HTML 5.1: Tag Name</a>
 */
public enum TagName {
    A(true),
    ASIDE,
    BUTTON(true),
    BLOCKQUOTE,
    BODY,
    BR(true),
    CAPTION,
    CODE(true),
    DD,
    DETAILS,
    DIV,
    DL,
    DT,
    EM(true),
    FOOTER,
    FORM,
    H1,
    H2,
    H3,
    H4,
    H5,
    H6,
    HEAD,
    HEADER,
    HR,
    HTML,
    I(true),
    IMG(true),
    INPUT(true),
    LABEL(true),
    LI,
    LISTING,
    LINK(true),
    MAIN,
    MENU,
    META,
    NAV,
    NOSCRIPT(true),
    OL,
    P,
    PRE,
    SCRIPT(true),
    SECTION,
    SMALL(true),
    SPAN(true),
    STRONG(true),
    SUB(true),
    SUMMARY,
    SUP(true),
    TABLE,
    TBODY,
    THEAD,
    TD,
    TH,
    TITLE,
    TR,
    UL,
    WBR(true);

    public final String value;
    public final boolean phrasingContent;

    static TagName of(String s) {
        return valueOf(s.toUpperCase(Locale.ROOT));
    }

    TagName() {
        this(false);
    }

    TagName(boolean phrasingContent) {
        this.value = Utils.toLowerCase(name());
        this.phrasingContent = phrasingContent;
    }

    public String toString() {
        return value;
    }

}
